﻿IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'VX_tr_OnDeleteRespondent'))
DROP TRIGGER VX_tr_OnDeleteRespondent
GO
CREATE TRIGGER VX_tr_OnDeleteRespondent
   ON  [Respondent]
   FOR DELETE
AS 
BEGIN
 SET NOCOUNT ON;

 DECLARE @iProjectId int
 SET @iProjectId = [dbo].GetProjectId(OBJECT_SCHEMA_NAME(@@PROCID))
 
 UPDATE dbo.ProjectStatistics 
 SET NeedsUpdate = 1
 WHERE ProjectId=@iProjectId AND NeedsUpdate=0

 DECLARE @count INT
 DECLARE @countUsed INT
 
 SELECT @count = COUNT(*) FROM deleted 
 SELECT @countUsed = COUNT(*) FROM deleted WHERE ResDisposition NOT IN (0,6)

 
 -----------------------------------------------------------------
 -- UPDATE email invitations statistics
 -----------------------------------------------------------------
 UPDATE dbo.VEM_EmailInvitation 
    SET [RespondentFilterCount] = [RespondentFilterCount] - (
         SELECT COUNT(DISTINCT VEM_InvitationHistory.RespondentId) 
          FROM dbo.VEM_InvitationHistory 
          JOIN deleted ON deleted.ResRespondent = VEM_InvitationHistory.RespondentId
          WHERE VEM_InvitationHistory.InvitationId = VEM_EmailInvitation.Id)
  WHERE VEM_EmailInvitation.ProjectId = @iProjectId

 DELETE FROM dbo.VEM_InvitationHistory
 WHERE Id IN(
  SELECT VEM_InvitationHistory.Id 
  FROM dbo.VEM_InvitationHistory
       JOIN dbo.VEM_EmailInvitation ON VEM_EmailInvitation.Id=VEM_InvitationHistory.InvitationId
       JOIN deleted ON deleted.ResRespondent = VEM_InvitationHistory.RespondentId 
  WHERE VEM_EmailInvitation.ProjectId=@iProjectId
  )

  UPDATE  smsd
	SET [RespondentFilterCount] = [RespondentFilterCount] - (
			SELECT COUNT(DISTINCT Distributions_SMS_History.RespondentId) 
			FROM dbo.Distributions_SMS_History 
			JOIN deleted ON deleted.ResRespondent = Distributions_SMS_History.RespondentId
			WHERE Distributions_SMS_History.DistributionId = d.Id)
	FROM dbo.Distributions_SMS_Distributions smsd
	INNER JOIN Distributions d on d.Id = smsd.Id
	WHERE d.SurveyId = @iProjectId


 DELETE FROM dbo.[Distributions_SMS_History]
 WHERE Id IN(
  SELECT [Distributions_SMS_History].Id 
  FROM dbo.[Distributions_SMS_History]
       JOIN dbo.Distributions ON Distributions.Id=[Distributions_SMS_History].DistributionId
       JOIN deleted ON deleted.ResRespondent = [Distributions_SMS_History].RespondentId 
  WHERE Distributions.SurveyId=@iProjectId
  )

  UPDATE Quota SET QtSample = QtSample - @count, QtUsed = QtUsed - @countUsed WHERE QtQuotaId = 0
END
GO
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[VX_tr_OnNewRespondent]'))
DROP TRIGGER VX_tr_OnNewRespondent
GO
CREATE TRIGGER VX_tr_OnNewRespondent
   ON  [Respondent]
   AFTER INSERT
AS 
BEGIN
	SET NOCOUNT ON;

	DECLARE @iProjectId int
	SET @iProjectId = [dbo].GetProjectId(OBJECT_SCHEMA_NAME(@@PROCID))
	
	UPDATE dbo.ProjectStatistics 
	SET NeedsUpdate = 1
	WHERE ProjectId=@iProjectId AND NeedsUpdate=0

	INSERT INTO RespondentActivitySummary (RespondentId, ProjectId, Disposition, Duration)
	SELECT ResRespondent,@iProjectId,0,0 FROM inserted	
END
GO